#!/bin/bash

# Definiere Farben für Logausgaben
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[0;33m'
NC='\033[0m' # No Color

# Funktion zum Loggen von Nachrichten
log() {
    echo -e "[$(date '+%Y-%m-%d %H:%M:%S')] $1"
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" >> /var/log/fileupload-watchdog.log
}

# Prüfe, ob der Service läuft
is_service_running() {
    if systemctl is-active --quiet fileupload.service; then
        return 0 # Service läuft
    else
        return 1 # Service läuft nicht
    fi
}

# Prüfe, ob der Server auf Port 80 antwortet
is_server_responding() {
    if curl -s -f -m 5 http://localhost/health-check > /dev/null; then
        return 0 # Server antwortet
    else
        return 1 # Server antwortet nicht
    fi
}

# Watchdog-Hauptlogik
log "${GREEN}Fileupload Watchdog gestartet${NC}"

if is_service_running; then
    log "${GREEN}Fileupload-Service läuft...${NC}"
else
    log "${RED}Fileupload-Service läuft nicht. Starte neu...${NC}"
    systemctl restart fileupload.service
    sleep 5
    
    if is_service_running; then
        log "${GREEN}Fileupload-Service wurde erfolgreich neu gestartet.${NC}"
    else
        log "${RED}Fehler beim Neustart des Fileupload-Service!${NC}"
    fi
fi

if is_server_responding; then
    log "${GREEN}Server antwortet auf dem Port 80.${NC}"
else
    log "${YELLOW}Server antwortet nicht auf Port 80. Überprüfe Verbindung...${NC}"
    
    # Prüfe, ob Port 80 blockiert ist
    if netstat -tuln | grep ":80 " > /dev/null; then
        log "${RED}Port 80 wird von einem anderen Prozess verwendet!${NC}"
        
        # Zeige Prozesse an, die Port 80 belegen
        OTHER_PROCESS=$(netstat -tulnp | grep ":80 ")
        log "Prozess auf Port 80: $OTHER_PROCESS"
        
        # Versuche den Fileupload-Service auf einem anderen Port zu starten
        if grep -q "PORT = 80" /var/www/html/fileupload/server.py; then
            log "${YELLOW}Ändere temporär den Port auf 8080...${NC}"
            # # sed -i 's/PORT = 80/PORT = 8080/' /var/www/html/fileupload/server.py
            systemctl restart fileupload.service
            log "${YELLOW}Fileupload-Service wurde auf Port 8080 neu gestartet. Bitte überprüfen Sie die Konfiguration!${NC}"
        fi
    else
        log "${YELLOW}Neustart des Dienstes...${NC}"
        systemctl restart fileupload.service
        sleep 5
        
        if is_server_responding; then
            log "${GREEN}Server antwortet jetzt auf Port 80.${NC}"
        else
            log "${RED}Server antwortet immer noch nicht. Versuche einen vollständigen Neustart...${NC}"
            systemctl stop fileupload.service
            sleep 2
            killall -9 python3 || true
            sleep 1
            systemctl start fileupload.service
            sleep 5
            
            if is_server_responding; then
                log "${GREEN}Server wurde erfolgreich wiederhergestellt.${NC}"
            else
                log "${RED}Konnte den Server nicht wiederherstellen! Manuelle Überprüfung erforderlich.${NC}"
            fi
        fi
    fi
fi

log "${GREEN}Watchdog-Ausführung abgeschlossen${NC}"
